﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Web.Security;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System.Net.Mail;
using System.Text.RegularExpressions;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for Customers.xaml
    /// </summary>
    public partial class Customers : Page
    {
        private static UserAccount UpdateCustomerID { get; set; }
        private static List<UserAccount> UserList { get; set; }

        public Customers()
        {
            InitializeComponent();
            LoadCustomerDetails();
        }
        /// <summary>
        /// Add Customer Event handler.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddCustomerInfo_Click(object sender, RoutedEventArgs e)
        {
            string ErrorText = string.Empty;
            if (ValidateEntry(out ErrorText))
            {
                UpdateCustomerID = btnAddCustomerInfo.Content.ToString() == UIConstants.ADD_CUSTOMER ? new UserAccount() : UpdateCustomerID;
                UpdateCustomerID.FirstName = txtFirstName.Text.Trim();
                UpdateCustomerID.LastName = txtLastName.Text.Trim();
                UpdateCustomerID.Email = txtEmail.Text.Trim();
                UpdateCustomerID.PhoneNo = txtPhone.Text.Trim();
                UpdateCustomerID.CustomerType = cbOccupation.Text;
                UpdateCustomerID.UserRoleType = "User";
                UpdateCustomerID.MobileNo = txtMobile.Text;
                UpdateCustomerID.Address1 = txtAddress1.Text;
                UpdateCustomerID.Address2 = txtAddress2.Text;
                UpdateCustomerID.Country = txtCountry.Text;
                UpdateCustomerID.StateProvince = txtState.Text;
                UpdateCustomerID.PostalCode = txtPostalCose.Text;
                UpdateCustomerID.City = txtCity.Text;

                //For Adding New Customer, Keep Email ID as UserName and Generate Auto Password.
                if (btnAddCustomerInfo.Content.ToString() == UIConstants.ADD_CUSTOMER)
                {
                    UpdateCustomerID.UserName = txtEmail.Text.Trim();
                    UpdateCustomerID.UPassword = ValidationUtility.EncryptPassword(Membership.GeneratePassword(8, 0));

                    List<UserAccount> listUser = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, txtEmail.Text.Trim(), DateTime.MinValue, DateTime.MinValue);
                    if (listUser != null && listUser.Count > 0)
                    {
                        listUser = listUser.Where(a => a.IsActive).ToList<UserAccount>();
                    }
                    if (listUser.Count == 0)
                    {
                        ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                         {
                             Dispatcher.BeginInvoke((Action)(() =>
                             {
                                 if (UserAccountBL.Save(UpdateCustomerID))
                                 {
                                     AppSession.SendWelcomeEmail(UpdateCustomerID);
                                     LoadCustomerDetails();
                                     ShowSuccessMessage("Added Customer Information Successfully");
                                 }
                             }));
                         });
                    }
                    else
                    {
                        MessageBox.Show("Customer already registered in POS", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                    }
                }
                //For updating existing User Call the Update Service with Customer's Unique ID
                else
                {
                    ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                        {
                            UpdateCustomerID.Mode = GlobalConfigurations.Mode.Update;
                            Dispatcher.BeginInvoke((Action)(() =>
                              {
                                  if (UserAccountBL.Save(UpdateCustomerID))
                                  {
                                      btnAddCustomerInfo.Content = UIConstants.ADD_CUSTOMER;
                                      lblHeaderText.Text = UIConstants.ADD_LABEL;
                                      LoadCustomerDetails();
                                      ShowSuccessMessage("Updated Customer Information Successfully");
                                  }
                                  else
                                  {
                                      MessageBox.Show("Error in updating Customer Details. Please try after some time!", "Error in Updating", MessageBoxButton.OK, MessageBoxImage.Error);
                                  }
                              }));
                        });
                }
            }
            else
            {
                MessageBox.Show(ErrorText, UIConstants.MANDATORY_FIELDS, MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
            }
        }

        /// <summary>
        /// Search Button Event Handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSearchCustomer_Click(object sender, RoutedEventArgs e)
        {
            LoadCustomerDetails(txtSearch.Text.Trim());
            btnClear.IsEnabled = true;
        }

        /// <summary>
        /// Validate the User details entered.
        /// </summary>
        /// <param name="ErrorText"></param>
        /// <returns></returns>
        private bool ValidateEntry(out string ErrorText)
        {
            //TODO Add validations for newly added fields based on the business logic.
            string ErrRequiredFields = string.Empty, ErrFormatErrors = string.Empty;
            if (string.IsNullOrEmpty(txtFirstName.Text.Trim()))
                ErrRequiredFields += UIConstants.FIRST_NAME;
            if (string.IsNullOrEmpty(txtLastName.Text.Trim()))
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.LAST_NAME);
            if (cbOccupation.SelectedIndex == -1)
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.OCCUPATION);
            if (string.IsNullOrEmpty(txtEmail.Text.Trim()))
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.EMAIL_ID);
            else
                ErrFormatErrors += ValidationUtility.ValidateEmail(txtEmail.Text.Trim()) ? string.Empty : UIConstants.EMAIL_FORMAT;

            if (!string.IsNullOrEmpty(txtPostalCose.Text) && !ValidationUtility.ValidateInt(txtPostalCose.Text.Trim()))
                ErrFormatErrors += UIConstants.POSTAL_CODE_FORMAT;

            if (!string.IsNullOrEmpty(txtMobile.Text) && !ValidationUtility.ValidatephoneNo(txtMobile.Text.Trim()))
                ErrFormatErrors += UIConstants.MOBILE_CODE_FORMAT;

            if (string.IsNullOrEmpty(txtPhone.Text.Trim()))
                ErrRequiredFields = ErrRequiredFields.AddError(UIConstants.PHONE_NUMBER);
            else
                ErrFormatErrors += ValidationUtility.ValidatephoneNo(txtPhone.Text.Trim()) ? string.Empty : UIConstants.PHONE_FORMAT;

            if (ErrRequiredFields.Empty() && ErrFormatErrors.Empty())
            {
                ErrorText = string.Empty;
                return true;
            }
            else
            {
                ErrorText = ErrRequiredFields.Empty() ? ErrFormatErrors : "Please enter " + ErrRequiredFields + "." + ErrFormatErrors;
                return false;
            }

        }

        /// <summary>
        /// Load the Customer Information from Database.
        /// </summary>
        private void LoadCustomerDetails(string Searchword = "")
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                Dispatcher.BeginInvoke((Action)(() =>
                {
                    List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, Searchword, DateTime.MinValue, DateTime.MinValue);
                    if (pbList != null && pbList.Count > 0)
                    {
                        pbList = pbList.Where(a => a.IsActive).ToList<UserAccount>();
                    }
                    UserList = pbList;
                    pbList = pbList.Where(a => a.UserRoleType.ToLower() == "user").ToList<UserAccount>();
                    gvCustomers.Dispatcher.BeginInvoke(new Action(() => gvCustomers.ItemsSource = pbList));
                    if (pbList.Count == 0)
                        MessageBox.Show("No matching customer records found! Please try again with a different name for results", "No Records Found", MessageBoxButton.OK, MessageBoxImage.Information);
                    btnClear.IsEnabled = false;
                }));
            });
        }

        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvCustomers, "CustomerReport");
        }

        public T FindChild<T>(DependencyObject parent, string childName) where T : DependencyObject
        {
            // Confirm parent and childName are valid. 
            if (parent == null) return null;

            T foundChild = null;

            int childrenCount = VisualTreeHelper.GetChildrenCount(parent);
            for (int i = 0; i < childrenCount; i++)
            {
                var child = VisualTreeHelper.GetChild(parent, i);
                // If the child is not of the request child type child
                T childType = child as T;
                if (childType == null)
                {
                    // recursively drill down the tree
                    foundChild = FindChild<T>(child, childName);

                    // If the child is found, break so we do not overwrite the found child. 
                    if (foundChild != null) break;
                }
                else if (!string.IsNullOrEmpty(childName))
                {
                    var frameworkElement = child as FrameworkElement;
                    // If the child's name is set for search
                    if (frameworkElement != null && frameworkElement.Name == childName)
                    {
                        // if the child's name is of the request name
                        foundChild = (T)child;
                        break;
                    }
                }
                else
                {
                    // child element found.
                    foundChild = (T)child;
                    break;
                }
            }

            return foundChild;
        }

        private void ShowSuccessMessage(string SuccessMsg)
        {
            MessageBox.Show(SuccessMsg, "Success", MessageBoxButton.OK, MessageBoxImage.Information);
            //LogicalTreeHelper.GetChildren(grdEditCustomers).OfType<TextBox>().ToList().ForEach(a => a.Clear());
            //LogicalTreeHelper.GetChildren(grdEditCustomers).OfType<ComboBox>().ToList().ForEach(a => a.SelectedIndex = -1);
            txtAddress1.Clear();
            txtFirstName.Clear();
            txtLastName.Clear();
            txtAddress2.Clear();
            txtCity.Clear();
            txtCountry.Clear();
            txtEmail.Clear();
            txtMobile.Clear();
            txtPhone.Clear();
            txtPostalCose.Clear();
            txtState.Clear();
            cbOccupation.SelectedIndex = -1;
        }

        private void txtEdit_MouseUp(object sender, MouseButtonEventArgs e)
        {
            var UniqueID = Guid.Parse((sender as TextBlock).Tag.ToString());
            UserAccount SelectedUser = UserList.Where(a => a.UniqueID == UniqueID).Select(a => a).Single();
            LoadSelectedUser(SelectedUser);
        }

        private void LoadSelectedUser(UserAccount SelectedUser)
        {
            txtFirstName.Text = SelectedUser.FirstName;
            txtLastName.Text = SelectedUser.LastName;
            txtEmail.Text = SelectedUser.Email;
            txtPhone.Text = SelectedUser.PhoneNo;
            cbOccupation.SelectedItem = (ComboBoxItem)cbOccupation.FindName(SelectedUser.CustomerType);
            txtMobile.Text = SelectedUser.MobileNo;
            txtAddress1.Text = SelectedUser.Address1;
            txtAddress2.Text = SelectedUser.Address2;
            txtCity.Text = SelectedUser.City;
            txtState.Text = SelectedUser.StateProvince;
            txtCountry.Text = SelectedUser.Country;
            txtPostalCose.Text = SelectedUser.PostalCode;
            btnAddCustomerInfo.Content = UIConstants.UPDATE_CUSTOMER;
            lblHeaderText.Text = UIConstants.UPDATE_LABEL;
            UpdateCustomerID = SelectedUser;
        }

        private void btnClear_Click(object sender, RoutedEventArgs e)
        {
            txtSearch.Clear();
            LoadCustomerDetails();
        }

        private void txtSearch_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Return)
            {
                LoadCustomerDetails(txtSearch.Text.Trim());
                btnClear.IsEnabled = true;
            }
        }
    }

    /// <summary>
    /// Custom Extension For Strings.
    /// </summary>
    public static class CustomExtenstion
    {
        public static bool Empty(this string str)
        {
            if (string.IsNullOrEmpty(str.Trim()))
                return true;
            else
                return false;

        }
        public static string AddError(this string str, string str1)
        {
            if (str.Empty())
                return str1;
            else
                return str + " , " + str1;
        }
    }
}
